<?php
/**
 * index.php
 * Easypay聚合支付系统
 * =========================================================
 * Copy right 2015-2025 Easypay, 保留所有权利。
 * ----------------------------------------------
 * 官方网址: http://www.0533hf.com
 *
 * 请尊重开发人员劳动成果，严禁使用本系统转卖、销售或二次开发后转卖、销售等商业行为。
 * 任何企业和个人不允许对程序代码以任何形式任何目的再发布。
 * =========================================================
 * @author : 366131726@qq.com
 * @date : 2019-05-14
 */
require 'config.php';


/**
 * 交易接口
 * 其他接口请求方式与本接口一样
 *
 */


//请求地址
$api = $gateway.'/pay';


//请求格式
$data = [
    'merId' => $merId,               //商户号
    'orderId' => time(),            //订单号，值允许英文数字
    'orderAmt' => 100,              //订单金额,单位元保留两位小数
    'channel' => 'wxsm',            //支付通道编码
    'desc' => '测试描述',           //简单描述，只允许英文数字 最大64
    'attch' => '66666',             //附加信息,原样返回
    'smstyle' => '1',               //用于扫码模式（sm），仅带sm接口可用，默认0返回扫码图片，为1则返回扫码跳转地址。
    'userId' => '',                 //用于识别用户绑卡信息，仅快捷接口可用。
    'ip' => '192.168.1.1',          //用户的ip地址必传，风控需要
    'notifyUrl' => "http://pay.0533hf.com/demo/notifyUrl.php",   //异步返回地址
    'returnUrl' => "http://pay.0533hf.com/demo/backUrl.php",     //同步返回地址
    'nonceStr' => Random::alnum('32')   //随机字符串不超过32位
];
//生成签名 请求参数按照Ascii编码排序



//私钥签名
$data['sign'] = sign($data,$md5Key,$privateKey);

$resp = Http::post($api, $data);

var_dump($resp);

